--- Kaliel's Tracker
--- Copyright (c) 2012-2019, Marouan Sabbagh <mar.sabbagh@gmail.com>
--- All Rights Reserved.
---
--- This file is part of addon Kaliel's Tracker.

local addonName, KT = ...
local M = KT:NewModule(addonName.."_AddonOthers")
KT.AddonOthers = M

local _DBG = function(...) if _DBG then _DBG("KT", ...) end end

-- WoW API
local _G = _G

local db
local OTF = ObjectiveTrackerFrame

local KTwarning = "  |cff00ffffAddon "..KT.title.." is active.  "

StaticPopupDialogs[addonName.."_ReloadUI"] = {
    text = KTwarning,
    button1 = "Reload UI",
    OnAccept = function()
        ReloadUI()
    end,
    timeout = 0,
    whileDead = true,
    preferredIndex = 3,
}

--------------
-- Internal --
--------------

-- ElvUI
local function ElvUI_SetSupport()
    if KT:CheckAddOn("ElvUI", "1.08", true) then
        KT.frame:SetScale(1)
        local E = unpack(_G.ElvUI)
        local B = E:GetModule("Blizzard")
        B.MoveQuestWatchFrame = function() end
    end
end

-- Tukui
local function Tukui_SetSupport()
    if KT:CheckAddOn("Tukui", "1.20", true) then
        KT.frame:SetScale(1)
        local T = unpack(_G.Tukui)
        T.Miscellaneous.ObjectiveTracker.Enable = function() end
    end
end

-- QuestLogEx
local function QuestLogEx_SetSupport()
    if IsAddOnLoaded("QuestLogEx") then
        QUESTS_DISPLAYED = 27
        QuestLogFrame = QuestLogExFrame
        QuestLogListScrollFrame = QuestLogExListScrollFrame

        hooksecurefunc("QuestLogTitleButton_OnClick", function(self, button)
            if not ((IsModifiedClick("CHATLINK") and ChatEdit_GetActiveWindow()) or IsShiftKeyDown()) then
                if not QuestLogEx.extended then
                    QuestLogEx:Maximize()
                end
            end
        end)

        hooksecurefunc("QuestObjectiveTracker_OpenQuestDetails", function(dropDownButton, questID)
            if not QuestLogEx.extended then
                QuestLogEx:Maximize()
            end
        end)
    end
end

--------------
-- External --
--------------

function M:OnInitialize()
    _DBG("|cffffff00Init|r - "..self:GetName(), true)
    db = KT.db.profile
end

function M:OnEnable()
    _DBG("|cff00ff00Enable|r - "..self:GetName(), true)
    ElvUI_SetSupport()
    Tukui_SetSupport()
    QuestLogEx_SetSupport()
end